/* This file is copyright (C) 2005 Andrew Collier
 * It may contain trade secret or proprietary information.
 * You may not copy, disclose, distribute, compile, modify
 * or otherwise use the contents of this file
 * except as explicitly agreed with the copyright holder
 */



var stateBoard = new Array(64);
var stateNextPlayer = 1;

var statePlayers = new Array(0,0,2);


function prefsKey(key)
{
	return widget.identifier + "-" + key;
}

function statusMessage(text)
{
    document.getElementById('toPlayText').innerText=text;
}


function setup()
{
	if(window.widget)		// always check to make sure that you are running in Dashboard
	{
	    for (var player=1;player<=2;player++) {
	
    		var playerString = widget.preferenceForKey(prefsKey("player"+player.toString()));
            if (playerString && playerString.length > 0) {
                statePlayers[player] = parseInt(playerString);
            }
            var popup = document.getElementById('player'+player+'Popup');
            popup.options[statePlayers[player]].selected = true;
        }
        
        widget.setCloseBoxOffset(27, 27);
	}

	NewGame();	
	
	createGenericButton (document.getElementById('doneButton'), 'Done', hidePrefs, 70);
	createGenericButton (document.getElementById('newgameButton'), 'New', NewGame, 50);

	
}


// changeWorld() is called whenever a menu item is chosen in the widget's preferences.  It queries the
// menu to find out which option was chosen, applies the change to the widget, and saves the preference.

function changePlayer(elem,player)
{	
    var newvalue = parseInt(elem.options[elem.selectedIndex].value);
    if (statePlayers[player] != newvalue) {
        widget.setPreferenceForKey(newvalue.toString(), prefsKey("player"+player.toString()) );
        statePlayers[player] = newvalue;
    }
} 


/*********************************/
// HIDING AND SHOWING PREFERENCES
/*********************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
		
	/* if the preferences have changed, it might be the computer's turn next */
	if (animatedPiecesTimer == null) {
	// if the animation is still going, this will get handled anyway so don't bother
	   nextMove();
	}
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, secondElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.secondElement = document.getElementById ('toPlayText');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.secondElement = document.getElementById ('toPlayText');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
	animation.secondElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

// ---------------------------------------------------------------------------



function createPlayingBoard (div) 
{
	// out with the old
	if (div.hasChildNodes()) {
		var children = div.childNodes;
		var count = children.length;
		for(var j=0; j < count; j++) {
			div.removeChild(children[0]);
		}
	}

	// and in with the new
	for (var i=0;  i<64; i++) {

		var spick = document.createElement("span");
		var x = (i%8)*20+40;
		var y = ((i-i%8)/8)*20+40;

		spick.setAttribute("class", "square");
		spick.setAttribute("id", i.toString());

		spick.setAttribute("onmousedown", "clickSquare(event, this.id);");

        spick.setAttribute("onmousemove" ,"squaremousemove(event, this.id);"); 
        spick.setAttribute("onmouseout", "squaremouseexit(event, this.id);");

		spick.style.position = "absolute";	

		spick.style.left = (i%8)*20+40 +"px";	
		spick.style.top = ((i-i%8)/8)*20+40 +"px";		

		spick.style.width = "20px";
		spick.style.height = "20px";
		
        spick.style.backgroundRepeat = "no-repeat";

		div.appendChild(spick);

		if (stateBoard[i] > 0) {
		    var p = stateBoard[i];
		    stateBoard[i] = 0;		  // fade in, don't rotate
			setSquare(i,p,0);
		}
	}
}


function NewGame() 
{
	for (var i=0;  i<64; i++) {
		stateBoard[i]=0;
	}
	
	stateBoard[27] = 1; 	stateBoard[28] = 2;
	stateBoard[35] = 2; 	stateBoard[36] = 1;

	createPlayingBoard (document.getElementById('board'));

	stateNextPlayer = 1;
    statusMessage("White to play");

    /* this can also be called by the button on the prefs
       if prefs are showing, flip to the game */
    if (front.style.display=="none") {
        hidePrefs();
    }

}


function clickSquare(event, id)
{
	var i = parseInt(id);

    if (stateNextPlayer== 0) {
    // reset game
        NewGame();
    
    } else if ((animatedPiecesTimer == null)  && (stateBoard[i] == 0)) {
/* disallow clicks whilst animation is still going on */
			
		if (flipSquares(i,stateNextPlayer,stateBoard, 1, 1) > 0) {

			setSquare(i,stateNextPlayer,0);
		
		    var passes = 0;
			do {
		
                stateNextPlayer = 3 - stateNextPlayer;
        
                var statusName = (stateNextPlayer == 1)?"White":"Black";
                
                var bestMove = computerPlay( stateNextPlayer, 1, 0, stateBoard);
                if (bestMove == -1) {
                    // must pass
                    passes = passes + 1;
                    statusMessage(statusName+" must pass");
                } else {
                    passes = 0;
                    statusMessage(statusName+" to play");
                }

            } while (passes==1);

            if (passes > 1) {
                // game over, count up and display winner
                score = new Array(0,0,0);
                
                for (var s=0;s<64;s++) {
                    score[stateBoard[s]] ++;
                }
                
                if (score[1] == score[2]) {
                    statusMessage("Game tied, "+score[1]+" each");
                } else if (score[1] > score[2]) {
                    statusMessage("White wins, "+score[1]+" to "+score[2]);
                } else {
                    statusMessage("Black wins, "+score[2]+" to "+score[1]);
                }
            
                stateNextPlayer = 0;
            
            }
            
		}
	}

}


var visualaidSquare = -1;
function squaremousemove(event, id) {
    id = parseInt(id);

    if ((statePlayers[stateNextPlayer]==0) && (id != visualaidSquare) && (animatedPieces.length == 0)) {
        if (stateBoard[id] == 0) {
            var validmove = flipSquares(id, stateNextPlayer, stateBoard, 0, 0);
        
            if (validmove>0) {
                var square = document.getElementById(id.toString());
                var imagenumber = (2-stateNextPlayer) * 16 + 1;
            
                square.style.backgroundImage = "url(\"Images/pieces"+(imagenumber<10?"0":"")+imagenumber+".png\")";
                square.style.opacity = 0.3+(stateNextPlayer-1)*.35; // black is harder to see, draw it more solid
            }
        }
        visualaidSquare = id;
        
    }
}


function squaremouseexit(event, id) {
    if (id == visualaidSquare) {
        if ((stateBoard[id] == 0)) {
            var square = document.getElementById(id.toString());
            square.style.backgroundImage = "";
        }
        visualaidSquare = -1;
    }
}


function nextMove() {

    if (statePlayers[stateNextPlayer] != 0) {
    /* computer to play */
		var level = statePlayers[stateNextPlayer];
		if (level == 3) {
			level = 4;
		}
        clickSquare(0, computerPlay(stateNextPlayer,1 ,level, stateBoard ));
    }                                

}


var animatedPieces = new Array(0);
var animatedPiecesTimer = null;

function setSquare(i, newvalue, timeoffset) {
	
	var square = document.getElementById(i.toString());
	var imagenumber = (2-newvalue) * 16 + 1;
	
	var starttime = (new Date).getTime() + timeoffset;
	
    var piece = { starttime:0, square:0, targetimage:0, animtype:0 };
    piece.starttime = starttime;
    piece.square = i;
    piece.targetimage=imagenumber;
    piece.animtype=(stateBoard[i]==0)?1:0;



    animatedPieces.push(piece); //append
	
	if (animatedPiecesTimer == null) {
	   animatedPiecesTimer = setInterval ("animatePieces();", 13);
	}
	

	stateBoard[i] = newvalue;    


}

function animatePieces() {
    var time = (new Date).getTime();

	if (animatedPieces.length > 0) {

	    for (var index=0; index<animatedPieces.length; index++) {
	        var piece = animatedPieces[index];
	        var T = (time - piece.starttime) / 300.0;
	        var imagenumber = piece.targetimage;
	        var square = document.getElementById(piece.square.toString());
	        if (T>1.0) {
	            square.style.opacity = 1;
	
	            // pop this animation for the list
	            animatedPieces.splice(index,1);
				index = index-1;
	
				if ((animatedPieces.length==0) && (statePlayers[stateNextPlayer] != 0)) {
					statusMessage(document.getElementById('toPlayText').innerText + " (thinking)");
				}


	
	
	        } else if (T> 0.0) {
	            if (piece.animtype == 1) {
	                square.style.opacity = T;
	            } else {
	                imagenumber = ((piece.targetimage - (16*(1.0-T)) + 31)%32) + 1;
	                imagenumber = imagenumber - imagenumber%1; // cast to int(!)
	            }
	        }
	        
	        if (T>0) {
	            square.style.backgroundImage = "url(\"Images/pieces"+(imagenumber<10?"0":"")+imagenumber+".png\")";
	        }
	    }

	} else {
		// no more animations
	
		clearInterval (animatedPiecesTimer);
     	animatedPiecesTimer = null;

        nextMove();
	}
}

var weightings = new Array (
   500, 1,70,40,40,70, 1,500,
    1,-40, 5, 5, 5, 5,-40,1,
    70, 5,15,10,10,15, 5,70,
    40, 5,10, 8, 8,10, 5,40,
    40, 5,10, 8, 8,10, 5,40,
    70, 5,15,10,10,15, 5,70,
    1,-40, 5, 5, 5, 5,-40,1,
   500, 1,70,40,40,70, 1,500
);
var hold = new Array (
   500,200,400,200,200,400,200,500,
     200,-30, 5, 5, 5, 5,-30,200,
      400, 5,15,10,10,15, 5,400,
      200, 5,10, 8, 8,10, 5,200,
      200, 5,10, 8, 8,10, 5,200,
      400, 5,15,10,10,15, 5,400,
     200,-30, 5, 5, 5, 5,-30,200,
   500,200,400,200,200,400,200,500
);
// spend extra effort around edges
// if there is a filled line from here to the corner, score at 100
// if there's a gap at one end and opponent at the other, score at minus gap's weighting
// else score at own weighting
function weight(board, player, move) {
	var value = 0;
	var opponent = 3-player;
	var home = 0;
	var away = 0;
	var avail = 0;

	for (var id=0; id<64; id ++) {
		if (board[id] == player) {
			value = value + hold[id];
			home ++;
		} else if (board[id] == opponent) {
			value = value - hold[id];
			away ++;
		} else {
			avail ++;
		}
	}
	
	value = value - hold[move] + weightings[move];

	return (avail>4)?value:(home-away);
}
	    
function old(id, board, player) {

	var value = weightings[id];
    if ((id<8) || (id>=56)) {
        var d = -1;
        var gap = 0;
        var opponent = 0;
        var endweight = 0;
        var i = id + d;
        while (((i%8) != 7) && (board[i]==player)) {
            i += d;
        }
        if ((i%8) == 7) {
            value = 100;
        } else {
            if (board[i]==0) {
                gap = 1;
                endweight = weightings[i];
            } else {
                opponent = 1;
            }
            
            d=1;
            i = id + d;
            while (((i%8) != 0) && (board[i]==player)) {
                i += d;
            } 
            if ((i%8) == 0) {
                value = 100;
            } else {
                if (board[i]==0) {
                    if (opponent) {
                        value = - weightings[i];
                    }
                } else {
                    if (gap) {
                        value = - endweight;
                    }
                }
            }
        }
    } else if (((id+1)%8) < 2) {
        var d = -8;
        var gap = 0;
        var opponent = 0;
        var endweight = 0;
        var i = id + d;
        while ((i>=0) && (board[i]==player)) {
            i += d;
        }
        if (i<0) {
            value = 100;
        } else {
            if (board[i]==0) {
                gap = 1;
                endweight = weightings[i];
            } else {
                opponent = 1;
            }
            
            d=8;
            i = id + d;
            while ((i<64) && (board[i]==player)) {
                i += d;
            } 
            if (i>=64) {
                value = 100;
            } else {
                if (board[i]==0) {
                    if (opponent) {
                        value = - weightings[i];
                    }
                } else {
                    if (gap) {
                        value = - endweight;
                    }
                }
            }
        }
    }
    return value;

    
}


var directions = new Array ( [0,1], [8,1], [8,0], [8,-1], [0,-1], [-8, -1], [-8,0], [-8,1]);
function flipSquares(moveid, player, board, screen, commit) {
	var countFlipped = 0;
	var opponent = 3-player;

	for (var dir=0; dir<8; dir++) {
		var d=directions[dir];
		var i = moveid;
		var invalid = 0;

        do {
            if (((i<8) && (d[0]<0)) || ((i>=56) && (d[0]>0)) 
                || (((i%8)==0) && (d[1]<0)) || (((i%8)==7) && (d[1]>0)) ) {
                invalid = 1;    
            } 
            i = i + d[0] + d[1];   
        } while ((!invalid) && (board[i] == opponent)); 
		
	    if ((!invalid) && (board[i]==player)) {
            var timeoffset = 100;
			i = moveid + d[0] + d[1];
			while (board[i] == opponent) {
				countFlipped = countFlipped + 1;
				if (screen) {
    				setSquare(i,player,timeoffset);
                    timeoffset=timeoffset+50;
	            } else if (commit) {
	               board[i] = player;
	            }
	
            	i += d[0] + d[1];
			}
		}
	}

	return countFlipped;
}


var boardCopy = new Array(new Array(), new Array(), new Array(), new Array());
function computerPlay( player, returnMove, level, board ) {
    var bestMove = -1;
    var bestMoveValue = -10000;
    var copyBoard = 1;
	var moveValue = -10000;

	var countWeightings = true;
	
	if (level==0) {
		level=1;
		countWeightings = false;
	}
	
    
	for (var move = 0; move < 64; move ++) {
        if (board[move] == 0) {
    
            // no built-in copy operator?!
            if (copyBoard) {
                for (var i=0; i<64; i++) {
                   boardCopy[level-1][i] = board[i];
                }
                copyBoard = 0;
            }
    
            var moveValid = flipSquares(move, player, boardCopy[level-1], 0, 1);
            if (moveValid > 0) {
				moveValue = 0;
                if (level > 1) {
                    boardCopy[level-1][move]=player;
                    opponentmove = computerPlay(3-player, 0, (player==stateNextPlayer)?(level-1):1, boardCopy[level-1]);
                    if (opponentmove > -10000) {
                        moveValue -= opponentmove;
                    }
                } else if (countWeightings) {
					boardCopy[level-1][move] = player;
					moveValue = weight(boardCopy[level-1], player, move);
					boardCopy[level-1][move] = 0;			
				} else {
					moveValue = 0;
				}
	
            
                if ((moveValue > bestMoveValue) || ((moveValue == bestMoveValue) && (Math.random() > move/64) )) {
                    bestMoveValue = moveValue;
                    bestMove = move;
                }
                copyBoard = 1;



            } 

//			if (returnMove && countWeightings) {
//				if (moveValid) {
//					document.getElementById(move.toString()).innerText=moveValue;
//				} else {
//					document.getElementById(move.toString()).innerText='';
//				}
//			}    

        }
    }

	if ((player!=stateNextPlayer) && (level>2) && (bestMove>-1)) {
	// we have short-cut the bottom of the tree by assuming the opponent is playing at level 1
	
    	for (var i=0; i<64; i++) {
            boardCopy[level-1][i] = board[i];
        }
		flipSquares(bestMove, player, boardCopy[level-1], 0, 1);
        opponentmove = computerPlay(3-player, 0, (player==stateNextPlayer)?(level-1):1, boardCopy[level-1]);
        if (opponentmove > -10000) {
            bestMoveValue -= opponentmove;
        }
	}


	if (returnMove && countWeightings) {
		document.getElementById(bestMove.toString()).style.color="yellow";	
	}

    
    return returnMove?bestMove:bestMoveValue;
}








